'use strict';


// Check if there are global options applied otherwise init.
if ( ! font_families )  {

	var font_families = [];
}

( function ( $ ) {

	// Avilable Google Fonts.
	var fonts = {
		'roboto'  					: 'Roboto',
		'roboto-condensed' 			: 'Roboto Condensed',
		'roboto-slab' 				: 'Roboto Slab',
		'roboto-mono'				: 'Roboto Mono',
		'open-sans' 				: 'Open Sans',
		'open-sans-condensed' 		: 'Open Sans Condensed',
		'lato' 						: 'Lato',
		'montserrat' 				: 'Montserrat',
		'montserrat-alternates' 	: 'Montserrat Alternates',
		'montserrat-subrayada' 		: 'Montserrat Subrayada',
		'oswald' 					: 'Oswald',
		'source-sans-pro' 			: 'Source Sans Pro',
		'source-serif-pro' 			: 'Source Serif Pro',
		'source-code-pro' 			: 'Source Code Pro',
		'slabo-27px' 				: 'Slabo 27px',
		'slabo-13px' 				: 'Slabo 13px',
		'raleway' 					: 'Raleway',
		'raleway-dots' 				: 'Raleway Dots',
		'pt-sans' 					: 'PT Sans',
		'pt-sans-caption' 			: 'PT Sans Caption',
		'pt-sans-narrow' 			: 'PT Sans Narrow',
		'pt-serif' 					: 'PT Serif',
		'pt-serif-caption' 			: 'PT Serif Caption',
		'merriweather' 				: 'Merriweather',
		'merriweather-sans' 		: 'Merriweather Sans',
		'ubuntu' 					: 'Ubuntu',
		'ubuntu-condensed' 			: 'Ubuntu Condensed',
		'ubuntu-mono' 				: 'Ubuntu Mono',
		'noto-sans' 				: 'Noto Sans',
		'noto-serif' 				: 'Noto Serif',
		'poppins' 					: 'Poppins',
		'playfair-display' 			: 'Playfair Display',
		'playfair-display-sc' 		: 'Playfair Display SC',
		'lora' 						: 'Lora',
		'titillium-web' 			: 'Titillium Web',
		'arimo' 					: 'Arimo',
		'multi' 					: 'Muli',
		'fira-sans' 				: 'Fira Sans',
		'fira-sans-condensed' 		: 'Fira Sans Condensed',
		'fira-sans-extra-condensed' : 'Fira Sans Extra Condensed',
		'fira-mono' 				: 'Fira Mono',
	};

	var font_elems 		= $('.mce-ga');
	var font_stack   	= [];
	var font_stack_unq  = [];

	// Get all page available fonts and font weight/styles
	$.each( font_elems, function( i, elem ) {

		font_stack.push($(elem)
			.attr('class')
				.replace('mce-ga', '')
					.replace('mce-family-', '')
						.replace('mce-styles-', '')
							.trim()
								.split(' '));
	});

	// Remove all duplicates.
	$.each( font_stack, function( i, font ) {

		if ( $.inArray( font[0], font_stack_unq ) === -1 ) {

			font_stack_unq.push( font[0] );
		}
	});

	// Bulild the Google Font families array.
	$.each( font_stack_unq, function( i, font ) {

		// Here check for font weight/style from the main stack
		// and assign it the font that's going to be loaded.
		if ( ! font_stack[i][1] ) {

			font_stack[i][1] = '';

		} else {

			font_stack[i][1] = ':' + font_stack[i][1];
		}

		// Build the GF array.
		if ( fonts[font] ) {

			font_families.push( fonts[font] + font_stack[i][1] );
		}
	});

	if ( font_families.length ) {

		// Load all Google Fonts for the current page.
		WebFont.load({
			google : {
		  		families : font_families
			}
		});
	}
} )( jQuery );