'use strict';

var Developry_Google_Fonts = ( function( $, dev ) {

	var Developry_Google_Fonts = function () {

		this.addToolbarMessage = function() {

			var $custom_toolbar = $('<div/>').attr('id', 'developry-custom-toolbar-message');
				$custom_toolbar.html(
					'<span class="developry-hint" title="Click on editor element to see the font fiamly/weight/style; Double click to select the whole element for update."><strong>Hint</strong> Click on editor element to see the font <em>fiamly/weight/style</em>; Double click to select the whole element for update.</span>'
				);

			$custom_toolbar.insertAfter('#insert-media-button');
		};

		this.addFont = function( editor, font, type ) {

			var formatted_content = '';
			var selected_content  = editor.selection.getContent( { format : 'html' } );

			// If no content is selected apply the font/style to the body
			if ( ! selected_content ) {

				selected_content = editor.getBody().innerHTML;
			}

			// Get HTML elements into nodes.
			var html_blocks = $.parseHTML(selected_content);

			// Add remove classes to the node elements.
			$.each( html_blocks, function(i, block) {

				// In case only text is seleted to style need to wrap it into <span/>
				if ( $(block).get(0).nodeType === 3 ) {

					formatted_content += '<span class="mce-ga mce-' + type  + '-' + font + '">' + $(block).get(0).nodeValue +'</span>';

				} else if ( $(block).get(0).tagName === 'SPAN' ) {

					// Reset and add first class set to SPAN.
					if ( $(block).get(0).className.match ( /(^|\s)mce-family-\S+/g)
						&& $(block).get(0).className.match ( /(^|\s)mce-styles-\S+/g) ) {
					
						$(block).get(0).className	= 'mce-ga  mce-' + type  + '-' + font;

					} else {
					
						// Append classes to current SPAN.
						$(block).get(0).className  	+= ' mce-' + type  + '-' + font;
					}

					formatted_content += '<span class="' + $(block).get(0).className + '">' + $(block).get(0).innerHTML +'</span>';

				} else {

					// The element doesn't have any styling yet, apply it.
					if ( ! $(block).hasClass( 'mce-ga' ) ) {

						$( block ).addClass( 'mce-ga mce-' + type  + '-' + font );

					} else {

						// Type is font-family we want remove all the existing classes and add the current one selected.
						if ( type === 'family') {

							$( block ).removeClass( function ( i, className ) {
	    						return ( className.match ( /(^|\s)mce-family-\S+/g) || [] ).join( ' ' );
							} ).addClass( 'mce-ga mce-' + type  + '-' + font );
						}

						// Type is font-weight we want remove all the existing classes and add the current one selected.
						if ( type === 'styles') {

							$( block ).removeClass( function ( i, className ) {
	    						return ( className.match ( /(^|\s)mce-styles-\S+/g) || [] ).join( ' ' );
							} ).addClass( 'mce-ga mce-' + type  + '-' + font );
						}
					}

					// Append all the formatted outer HTML.
					formatted_content += block.outerHTML;
				}
			});

			// Replace if we have selected content, otherwise update the full body content.
			if ( editor.selection.getContent( { format : 'html' } ) ) {

				editor.selection.setContent( formatted_content, { format : 'html' } );

			} else {

				editor.setContent( formatted_content, { format : 'html' } );
			}
		}
	}

	return Developry_Google_Fonts;

} )( jQuery, Developry );

var Developry = Developry || {};

// Initialize all the classes loaded with wp_enqueue_script()
Developry.gfonts = new Developry_Google_Fonts;

( function ( $, dev ) {

	'use strict';

	// Create and append the custom toolbar hit message after Add Media button.
	dev.gfonts.addToolbarMessage();

	// Initialize.
	tinymce.create( 'tinymce.plugins.developry_google_fonts', {

		init : function( editor, url ) {

			var typefaces  = {
				'roboto'  					: 'Roboto',
				'roboto-condensed' 			: 'Roboto Condensed',
				'roboto-slab' 				: 'Roboto Slab',
				'roboto-mono'				: 'Roboto Mono',
				'open-sans' 				: 'Open Sans',
				'open-sans-condensed' 		: 'Open Sans Condensed',
				'lato' 						: 'Lato',
				'montserrat' 				: 'Montserrat',
				'montserrat-alternates' 	: 'Montserrat Alternates',
				'montserrat-subrayada' 		: 'Montserrat Subrayada',
				'oswald' 					: 'Oswald',
				'source-sans-pro' 			: 'Source Sans Pro',
				'source-serif-pro' 			: 'Source Serif Pro',
				'source-code-pro' 			: 'Source Code Pro',
				'slabo-27px' 				: 'Slabo 27px',
				'slabo-13px' 				: 'Slabo 13px',
				'raleway' 					: 'Raleway',
				'raleway-dots' 				: 'Raleway Dots',
				'pt-sans' 					: 'PT Sans',
				'pt-sans-caption' 			: 'PT Sans Caption',
				'pt-sans-narrow' 			: 'PT Sans Narrow',
				'pt-serif' 					: 'PT Serif',
				'pt-serif-caption' 			: 'PT Serif Caption',
				'merriweather' 				: 'Merriweather',
				'merriweather-sans' 		: 'Merriweather Sans',
				'ubuntu' 					: 'Ubuntu',
				'ubuntu-condensed' 			: 'Ubuntu Condensed',
				'ubuntu-mono' 				: 'Ubuntu Mono',
				'noto-sans' 				: 'Noto Sans',
				'noto-serif' 				: 'Noto Serif',
				'poppins' 					: 'Poppins',
				'playfair-display' 			: 'Playfair Display',
				'playfair-display-sc' 		: 'Playfair Display SC',
				'lora' 						: 'Lora',
				'titillium-web' 			: 'Titillium Web',
				'arimo' 					: 'Arimo',
				'multi' 					: 'Muli',
				'fira-sans' 				: 'Fira Sans',
				'fira-sans-condensed' 		: 'Fira Sans Condensed',
				'fira-sans-extra-condensed' : 'Fira Sans Extra Condensed',
				'fira-mono' 				: 'Fira Mono',
			}

			var styles = {
				'100'  : 'Thin',
				'100i' : 'Thin Italic',
				'200'  : 'Extra Light',
				'200i' : 'Extra Light Italic',
				'300'  : 'Light',
				'300i' : 'Light Italic',
				'400'  : 'Regular',
				'400i' : 'Regular Italic',
				'500'  : 'Medium',
				'500i' : 'Medium Italic',
				'600'  : 'Semi Bold',
				'600i' : 'Semi Bold Italic',
				'700'  : 'Bold',
				'700i' : 'Bold Italic',
				'800'  : 'Extra Bold',
				'800i' : 'Extra Bold Italic',
				'900'  : 'Black',
				'900i' : 'Black Italic',
			}

			//  Double click to select the whole element for update.
			editor.on( 'dblclick', function( elem ) {

					editor.selection.select( $( elem.target ).get(0) );
				}
			);

			// Add TinyMCE Toolbar button groups.
			editor.addButton( 'developry_google_font_family_button', 
				{
					type  			: 'listbox',
					name  			: 'font-family',
					icon  			: 'dashicon dashicons-admin-appearance',
					value 		 	: '',
					onpostrender	: function() { change_button_node( this, 'family', typefaces ) },
					values 		  	: load_button_values( editor, 'family', typefaces ),
				} 
			);

			editor.addButton( 'developry_google_font_styles_button', 
				{
					type  			: 'listbox',
					name  			: 'font-styles',
					icon  			: 'dashicon dashicons-filter',
					value 			: '',
					onpostrender 	: function() { change_button_node( this, 'styles', styles ) },
					values 			: load_button_values( editor, 'styles', styles ),
				} 
			);

			// Call to the action function that will add/update element font options.
			function on_click( editor, option, type ) {

				dev.gfonts.addFont( editor, option, type );
			}

			// Load the up plugin Google font typefaces and styles.
			function load_button_values( editor, type, options ) {

				var values = [];

				if ( 'family' === type ) {

					// Add the top lvl empty value.
					values.push({
						text    : 'Select typeface...',
						value 	: '',
						onclick : function( event ) {
							alert( 'Make a selection and then choose your font typeface...' );
						},
					});
					
				} else if ( 'styles' === type ) {

					// Add the top lvl empty value.
					values.push({
						text    : 'Select weight & style...',
						value 	: '',
						onclick : function( event ) {
							alert( 'Make a selection and then choose your font weight & style...' );
						},
					});
				}

				// Loop over the options and build the listbox button group body.
				$.each( options, function( key, font ) {

					values.push({
						text 	: font,
						classes : type + '-' + key,
						value 	: key,
						onclick : function() { on_click( editor, key, type ) },
					});
				});

				return values;
			}

			// Change the Toolbar listbox value with the selected element Google font family / weight & style.
			function change_button_node( pthis, type, options ) {

	  			var listbox = pthis;
	  			var opt     = options;

	  			editor.on( 'NodeChange', function( e ) {

		  			var selected = [];

	  				if ( $( e.element ).hasClass( 'mce-ga' ) )  {

	  					var gfont_options = $( e.element ).attr( 'class' )
							.replace( 'mce-ga', '' )
								.replace( 'mce-family-', '' )
									.replace( 'mce-styles-', '' )
										.trim()
											.split( ' ' );

		  				selected.push( gfont_options );

		  				if ( listbox.value ) {

		  					// // Each family and styles can be set as 0 or 1 options.
			  				if ( 'family' === type ) {

			  					if ( opt.hasOwnProperty( selected[0][0] ) ) {

			  						listbox.value( selected[0][0] );
			  					}
			  					else {

			  						listbox.value( selected[0][1] );
			  					}

			  				} else {

			  					if ( opt.hasOwnProperty( selected[0][1] ) ) {

			  						listbox.value( selected[0][1] );
			  					}
			  					else {

			  						listbox.value( selected[0][0] );
			  					}
			  				}
			  			}
		  			}

		  			// Reset.
		  			if ( ! selected.length ) {

		  				listbox.value( '' );
		  			}
	  			});
			}
		}
	} );

	// Add & execute our plugin to the plugin manager.
	tinymce.PluginManager.add( 'developry_google_fonts', tinymce.plugins.developry_google_fonts );

} )( jQuery, Developry );
