<?php
/**
	Plugin Name:  Develop(ry) Google Fonts
	Plugin URL:   https://developry.com/developry-google-fonts
	Description:  Load up the 20 most popular Google Fonts and use them to style your post and page content.
	Version:      1.0.3
	Author: 	  Krasen Slavov
	Author URI:   https://developry.com/author/krasen
	License:      GNU General Public License, version 2
	License URI:  https://www.gnu.org/licenses/gpl-2.0.html
	Text Domain:  developry-google-fonts
*/


/**
 * Don't allow to access this script directly, exit.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Main class for the plugin
 * @package Developry
 * @subpackage Developry_Google_Fonts
 * @author Krasen Slavov
 */
if( ! class_exists( 'Developry_Google_Fonts' ) ) :

class Developry_Google_Fonts {

	// @var $_instance Store the instance of our class.
	public static $_instance;

	// @var $plugin_url Plugin URL used to load scripts and styles.
	public $plugin_url;

	// @var $plugin_name Plugin formal name same as textdomain.
	public $plugin_name;

	// @var $plugin_name Plugin current version.
	public $plugin_version;

	// @var $google_fonts List with all Google Font typefaces.
	private $google_fonts = array(
		'roboto'  					=> 'Roboto',
		'roboto-condensed' 			=> 'Roboto Condensed',
		'roboto-slab' 				=> 'Roboto Slab',
		'roboto-mono'				=> 'Roboto Mono',
		'open-sans' 				=> 'Open Sans',
		'open-sans-condensed' 		=> 'Open Sans Condensed',
		'lato' 						=> 'Lato',
		'montserrat' 				=> 'Montserrat',
		'montserrat-alternates' 	=> 'Montserrat Alternates',
		'montserrat-subrayada' 		=> 'Montserrat Subrayada',
		'oswald' 					=> 'Oswald',
		'source-sans-pro' 			=> 'Source Sans Pro',
		'source-serif-pro' 			=> 'Source Serif Pro',
		'source-code-pro' 			=> 'Source Code Pro',
		'slabo-27px' 				=> 'Slabo 27px',
		'slabo-13px' 				=> 'Slabo 13px',
		'raleway' 					=> 'Raleway',
		'raleway-dots' 				=> 'Raleway Dots',
		'pt-sans' 					=> 'PT Sans',
		'pt-sans-caption' 			=> 'PT Sans Caption',
		'pt-sans-narrow' 			=> 'PT Sans Narrow',
		'pt-serif' 					=> 'PT Serif',
		'pt-serif-caption' 			=> 'PT Serif Caption',
		'merriweather' 				=> 'Merriweather',
		'merriweather-sans' 		=> 'Merriweather Sans',
		'ubuntu' 					=> 'Ubuntu',
		'ubuntu-condensed' 			=> 'Ubuntu Condensed',
		'ubuntu-mono' 				=> 'Ubuntu Mono',
		'noto-sans' 				=> 'Noto Sans',
		'noto-serif' 				=> 'Noto Serif',
		'poppins' 					=> 'Poppins',
		'playfair-display' 			=> 'Playfair Display',
		'playfair-display-sc' 		=> 'Playfair Display SC',
		'lora' 						=> 'Lora',
		'titillium-web' 			=> 'Titillium Web',
		'arimo' 					=> 'Arimo',
		'multi' 					=> 'Muli',
		'fira-sans' 				=> 'Fira Sans',
		'fira-sans-condensed' 		=> 'Fira Sans Condensed',
		'fira-sans-extra-condensed' => 'Fira Sans Extra Condensed',
		'fira-mono' 				=> 'Fira Mono',
	);

	// @var $google_styles List with all Google Font styles and weights.
	private $google_styles = array(
		'100'  => 'Thin',
		'100i' => 'Thin Italic',
		'200'  => 'Extra Light',
		'200i' => 'Extra Light Italic',
		'300'  => 'Light',
		'300i' => 'Light Italic',
		'400'  => 'Regular',
		'400i' => 'Regular Italic',
		'500'  => 'Medium',
		'500i' => 'Medium Italic',
		'600'  => 'Semi Bold',
		'600i' => 'Semi Bold Italic',
		'700'  => 'Bold',
		'700i' => 'Bold Italic',
		'800'  => 'Extra Bold',
		'800i' => 'Extra Bold Italic',
		'900'  => 'Black',
		'900i' => 'Black Italic',
	);

	// @var $google_global_font_option List with all the option keys (names) stored into DB.
	private $google_global_font_option = array(
		'body_text_font_typeface',
		'body_text_font_styles',
		'heading_1_font_typeface',
		'heading_1_font_styles',
		'heading_2_font_typeface',
		'heading_2_font_styles',
		'heading_3_font_typeface',
		'heading_3_font_styles',
		'heading_4_font_typeface',
		'heading_4_font_styles',
		'heading_5_font_typeface',
		'heading_5_font_styles',
		'heading_6_font_typeface',
		'heading_6_font_styles',
	);

	// @var $google_tags Relation between options and HTML tags/classes
	private $google_tags = array(
		'body_text_font_typeface' 	=> 'p,ol,li',
		'body_text_font_styles' 	=> '',
		'heading_1_font_typeface' 	=> 'h1,.h1,.display-1',
		'heading_1_font_styles' 	=> '',
		'heading_2_font_typeface' 	=> 'h2,.h2,.display-2',
		'heading_2_font_styles' 	=> '',
		'heading_3_font_typeface' 	=> 'h3,.h3,.display-3',
		'heading_3_font_styles'	 	=> '',
		'heading_4_font_typeface' 	=> 'h4,.h4,.display-4',
		'heading_4_font_styles' 	=> '',
		'heading_5_font_typeface' 	=> 'h5,.h5',
		'heading_5_font_styles'	 	=> '',
		'heading_6_font_typeface' 	=> 'h6,.h6',
		'heading_6_font_styles'		=> '',
	);

	/**
	 * Constructor.
	 */
	public function __construct() {

		// Check if the minimum PHP 5.3 & WordPress 4.7 versions are avialalbe.
		if ( version_compare( PHP_VERSION, '5.3.0', '<' )
			&& version_compare( $GLOBALS['wp_version'], '4.7-alpha', '<' ) ) {

			add_action(
				'admin_notices',
				array(
					$this,
					'show_minimum_support_notice'
				)
			);

		} else  {

			self::define();
			self::init();
		}
	}

	/**
	 * Instantiate the plugin.
	 */
	public static function instance() {

		if ( is_null( self::$_instance ) ) {

			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * Define plugin url, name, version and filename as class.
	 */
	public function define(){

		define( 'Developry_Google_Fonts', __FILE__ );

		$this->plugin_url     = plugins_url( '', __FILE__ );
		$this->plugin_name    = 'developry-google-fonts';
		$this->plugin_version = '1.0.0';
	}

	/**
	 * Load up plugin scripts, stylesheets and functionalities.
	 */
	public function init() {

		add_action(
			'init',
			array(
				$this,
				'permissions',
			)
		);

		add_action(
			'mce_external_plugins',
			array(
				$this,
				'register_tinymce_plugin',
			)
		);

		add_action(
			'mce_buttons',
			array(
				$this,
				'add_tinymce_buttons',
			)
		);

		add_action(
			'wp_head',
			array(
				$this,
				'enqueue_front_styles',
			)
		);

		add_action(
			'wp_footer',
			array(
				$this,
				'enqueue_front_scripts',
			)
		);

		add_action(
			'admin_enqueue_scripts',
			array(
				$this,
				'enqueue_admin_styles',
			)
		);

		add_action(
			'admin_enqueue_scripts',
			array(
				$this,
				'enqueue_admin_scripts',
			)
		);

		add_action(
			'admin_menu', 
			array(
				$this,
				'add_admin_menu_page',
			)
		);

		add_editor_style( $this->plugin_url . '/assets/css/developry-google-fonts.css' );
	}

	/**
	 * The user would be able to have access to edit posts and pages to use our plugin.
	 */
	public function permissions() {

		if ( ! current_user_can( 'edit_posts' )
			&& ! current_user_can( 'edit_pages' )
			&& get_user_option( 'rich_editing' ) == 'true' ) {

			return;
		}
	}

	/**
	 * Add additional custom CSS stylesheets for our plugin.
	 */
	public function enqueue_admin_styles() {

		wp_enqueue_style(
			$this->plugin_name . '',
			$this->plugin_url . '/assets/css/developry-google-fonts.css',
			null,
			null,
			'all'
		);
	}

	public function enqueue_front_styles() {

		wp_enqueue_style(
			$this->plugin_name . '-ga-front',
			$this->plugin_url . '/assets/css/developry-google-fonts-front.css',
			null,
			null,
			'all'
		);

		if ($this->google_global_font_option) {

			$dynamic_style_text = '';

			

			foreach ( $this->google_global_font_option as $option ) {

				if ( get_option( $option ) ) {

					$dynamic_style_text .= $this->google_tags[$option] . ' {font-family: "' . get_option( $option ) . '", sans-serif;} ';
				}
			}
		
			wp_add_inline_style( $this->plugin_name . '-ga-front',  $dynamic_style_text );
		}
	}

	/**
	 * Add additional custom JS files for our plugin.
	 */
	public function enqueue_admin_scripts() {

		// wp_enqueue_script(
		// 	$this->plugin_name,
		// 	$this->plugin_url . '/',
		// 	array( 'jquery' ),
		// 	null,
		// 	true
		// );
	}

	public function enqueue_front_scripts() {

		wp_enqueue_script(
			$this->plugin_name . '-webfont',
			'https://ajax.googleapis.com/ajax/libs/webfont/1.6.26/webfont.js',
			null,
			true
		);

		wp_enqueue_script(
			$this->plugin_name . '-ga-front-js',
			$this->plugin_url . '/assets/js/developry-google-fonts-front.js',
			array( 'jquery' ),
			null,
			true
		);

		// Set all global Google Fonts into array dynamically for webfont.js to load.
		if ( $this->google_global_font_option ) {

			$fonts_typeface_styles = [];
			$google_fonts = [];


			// Match font typefaces with styles
			foreach ( $this->google_global_font_option as $option ) {

				// Get style vaule based on the option selected. 400 <> Regular.
				$google_style = array_search( get_option( $option ), $this->google_styles );
				$pattern 	  = str_replace( '_styles', '', str_replace('_typeface', '', $option ) );

				// Adds style value otherwize add the typeface
				if ( $google_style ) {

					$fonts_typeface_styles[$pattern][] = $google_style;

				} else {

					$fonts_typeface_styles[$pattern][] = get_option( $option );
				}
			}

			// Get all unique Google Fonts options.
			$fonts_typeface_styles = array_map( 'json_encode', $fonts_typeface_styles );
			$fonts_typeface_styles = array_unique( $fonts_typeface_styles );
			$fonts_typeface_styles = array_map( 'json_decode', $fonts_typeface_styles );

			// Create Google Fonts to load with [typeface:style] or attach styles sep with ','.
			if ( $fonts_typeface_styles['body_text_font'][0] ) {

				foreach ( $fonts_typeface_styles as $option_group ) {

					if ( array_key_exists( $option_group[0], $google_fonts ) ) {

	 					$google_fonts[$option_group[0]] .= ',' . $option_group[1];

					} else if ($option_group[0]) {

						$google_fonts[$option_group[0]] = implode( ':', $option_group );
					}

					// Strip the trailing ',' from Google Font option string.
					if ( ! empty($google_fonts[$option_group[0]]) && substr($google_fonts[$option_group[0]], -1) === ',' ) {

						$google_fonts[$option_group[0]] = substr($google_fonts[$option_group[0]], 0, -1);
					}
				}
			}

			if ( $google_fonts ) {

				$dynamic_script_text = 'var font_families = [';

				foreach ( $google_fonts as $font ) {

					if ( $font ) {

						$dynamic_script_text .= "'" . $font . "',";
					}
				}

				$dynamic_script_text = substr($dynamic_script_text, 0, -1);
				$dynamic_script_text .= '];';

				wp_add_inline_script( $this->plugin_name . '-ga-front-js',  $dynamic_script_text, 'before' );
			}
		}
	}

	/**
	 * Register our plugin into the TinyMCE and load all components body for editor.windowManager.
	 *
	 * @param $plugins This will contain all the TinyMCE plugins loaded.
	 * @return array $plugins
	 */
	public function register_tinymce_plugin( $plugins ) {

		// This is the main JS files that will handle TinyMCE customization.
		$plugins['developry_google_fonts'] = $this->plugin_url . '/assets/js/developry-google-fonts.js';

		return $plugins;
	}

	/**
	 * Add plugin button into the TinyMCE toolbar.
	 *
	 * @param $plugins This will contain all TinyMCE toolbar available buttons.
	 * @return array $buttons
	 */
	public function add_tinymce_buttons( $buttons ) {

		array_unshift(
			$buttons,
			'developry_google_font_family_button',
			'developry_google_font_styles_button'
		);

		return $buttons;
	}

	/**
	 * Add PHP version notice if below 5.3.
	 */
	public function show_minimum_support_notice() {

		 $class = 'notice notice-error';

		 $message = '<strong>Developry Google Fonts</strong> requires PHP version 5.3 and WordPress 4.7 or above. You are running PHP ' . PHP_VERSION . ' and WordPress ' . $GLOBALS['wp_version'] . '. Please upgrade to the minimum supported versions for the plugin to be loaded.';

		return '<div class="' . $class . '">' . $message . '</div>';
	}

	/**
	 * Add plugin WP admin Developry menu.
	 */
	public function add_admin_menu_page(){

		add_menu_page(
			'Developry',
			'Developry',
			'manage_options',
			'developry-main',
			array(
				$this, 
				'developry_main',
			),
			'dashicons-admin-tools',
			1001
		);

		add_submenu_page( 
			'developry-main', 
			'Developry Google Fonts', 
			'Developry Google Fonts', 
			'manage_options', 
			'developry-google-fonts',
			array(
				$this, 
				'developry_google_fonts',
			)
		);
	}

	/**
	 * Show up the following content for Developry main link.
	 */
	public function developry_main() {

		// Must check that the user has the required capability.
    	if ( ! current_user_can('manage_options' ) ) {

      		wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
    	}

    	print '<div class="wrap"><div id="welcome" class="welcome-panel"><div class="welcome-panel-content">';
    	print '<h2>Thank you for choosing Develop(ry)!</h2><hr />';
    	print '<p class="about-description">Develop(ry) is a collection of WordPress themes and plugins.</p>
			<p>Our goal is to improve your WordPress experience with useful and practical tools that will make it easy to manage your website content without any additional hassle or overhead.</p>
			<p>The person behind responsible for development and maintenance is <a href="http://developry.com/author/krasen/"><strong>Krasen Slavov</strong></a>.</p> 
			<p>If you use and like our FREE themes and plugins please consider to support us and <a href="https://developry.com/donate" class="button" target="_blank">donate</a></p> 
			<p>Any help would be greatly appreciated.</p>
			<h3>DEVELOP(RY) PLUGINS AND LINKS TO THEIR DOCUMENTATION PAGES</h3>
			<hr />
			<ul>
    			<li>&mdash; <a href="https://developry.com/developry-google-fonts/" target="_blank"><strong>Developry Google Fonts</strong></a> - WordPress plugin that will load up the 20 most popular Google Fonts in your editor. </li>
    		</ul>';
    	print '</div></div></div>';
	}

	/**
	 * Show up the following content for Developry Google Fonts link.
	 */
	public function developry_google_fonts() {

		$message = '';

		// Must check that the user has the required capability.
    	if ( ! current_user_can('manage_options' ) ) {

      		wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
    	}

		if ( ! empty( $_POST['developry-google-fonts-form-submitted'] ) ){
			
			$message = $this->update_developry_google_fonts( $_POST );
		}

		$this->display_google_fonts_form( $message );
	}

	/**
	 * Add/update (store) developry fonts options into WP for later use
	 *
	 * @param array $post User selection.
	 * @return string $message Text message to show to user.
	 */
	private function update_developry_google_fonts( $post ) {

		$check = false;

		array_shift($post);
		array_pop($post);

		foreach ($post as $key => $option) {

			if ( $option ) {

				if ( get_option( $key ) ) {

					update_option( $key, $option, 'yes' );

				} else {

					add_option( $key, $option, '64', 'yes' );
				}

				$check = true;
			} 

			update_option( $key, $option, 'yes' );
		}

		if ( $check === false ) {

			return 'Nothing was added/updated.';
	
		} else {

			return 'Font selection was completed successfully. Go to your site front-end to view the changes.';
		}
	}

	/**
	 * Build the the font select options based on user selection and options stored in the DB.
	 *
	 * @param string $type Either 'typeface' or 'styles'
	 * @param string $selected_option Selected option by the user stored in DB.
	 * @return string Print <option />.
	 */
	private function load_google_font_options( $type, $selected_option ) {

		if ( $type === 'typeface' ) {

			$google_font_values = $this->google_fonts;

		} else {

			$google_font_values = $this->google_styles;
		}

		array_walk( $google_font_values, function( &$value, $key, $selected_option ) {

			if ( $selected_option === $value) {

				print '<option value="' . $value . '" selected>' . $value . '</option>';
			
			} else {

				print '<option value="' . $value . '">' . $value . '</option>';
			}
		}, $selected_option );
	}

	/**
	 * Print our the Google Fonts selection form.
	 *
	 * @return string $message Text message to show to user.
	 */
	private function display_google_fonts_form( $msg ) {

		print '<div class="wrap"><div id="welcome" class="welcome-panel"><div class="welcome-panel-content">';
    	print '<h2>Developry Google Fonts</h2><hr />';
    	print '<p class="about-description">WordPress plugin that will load up the 20 most popular Google Fonts in your editor.</p>
    		<p><big>Additonally to stylting your website content directly from the WordPress editor you have the option to select global fonts and apply typeface and style and weight to body text and headings.</big></p> 
    		<p><strong>Note: All styling applied via the WYSIWYG editor will overwrite these global element font settings. Also some of the classes shown below are Bootstrap specific.</strong></p>';
?>
	<form name="developry-google-fonts-form" method="post" action="?page=developry-google-fonts">
		<input type="hidden" name="developry-google-fonts-form-submitted" value="1" />
		<table class="form-table">
			<tbody>
				<tr>
					<th scope="row">
						<label>
							Body Text
						</label>
					</th>
					<td>
						<select name="body_text_font_typeface">
							<option value="">Select typeface...</option>
							<?php
								$this->load_google_font_options( 'typeface', get_option( 'body_text_font_typeface' ) );
							?>
						</select>
						&nbsp;&nbsp;&nbsp;
						<select name="body_text_font_styles">
							<option value="">Select weight &amp; style...</option>
							<?php
								$this->load_google_font_options( 'styles', get_option( 'body_text_font_styles' ) );
							?>
						</select>
						&nbsp;&nbsp;&nbsp;
						(p, ul, ol, etc.)
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label>
							Heading 1
						</label>
					</th>
					<td>
						<select name="heading_1_font_typeface">
							<option value="">Select typeface...</option>
							<?php
								$this->load_google_font_options( 'typeface', get_option( 'heading_1_font_typeface' ) );
							?>
						</select>
						&nbsp;&nbsp;&nbsp;
						<select name="heading_1_font_styles">
							<option value="">Select weight &amp; style...</option>
							<?php
								$this->load_google_font_options( 'styles', get_option( 'heading_1_font_styles' ) );
							?>
						</select>
						&nbsp;&nbsp;&nbsp;
						(h1, .h1, .display-1)
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label>
							Heading 2
						</label>
					</th>
					<td>
						<select name="heading_2_font_typeface">
							<option value="">Select typeface...</option>
							<?php
								$this->load_google_font_options( 'typeface', get_option( 'heading_2_font_typeface' ) );
							?>
						</select>
						&nbsp;&nbsp;&nbsp;
						<select name="heading_2_font_styles">
							<option value="">Select weight &amp; style...</option>
							<?php
								$this->load_google_font_options( 'styles', get_option( 'heading_2_font_styles' ) );
							?>
						</select>
						&nbsp;&nbsp;&nbsp;
						(h1, .h2, .display-2)
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label>
							Heading 3
						</label>
					</th>
					<td>
						<select name="heading_3_font_typeface">
							<option value="">Select typeface...</option>
							<?php
								$this->load_google_font_options( 'typeface', get_option( 'heading_3_font_typeface' ) );
							?>
						</select>
						&nbsp;&nbsp;&nbsp;
						<select name="heading_3_font_styles">
							<option value="">Select weight &amp; style...</option>
							<?php
								$this->load_google_font_options( 'styles', get_option( 'heading_3_font_styles' ) );
							?>
						</select>
						&nbsp;&nbsp;&nbsp;
						(h3, .h3, .display-3)
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label>
							Heading 4
						</label>
					</th>
					<td>
						<select name="heading_4_font_typeface">
							<option value="">Select typeface...</option>
							<?php
								$this->load_google_font_options( 'typeface', get_option( 'heading_4_font_typeface' ) );
							?>
						</select>
						&nbsp;&nbsp;&nbsp;
						<select name="heading_4_font_styles">
							<option value="">Select weight &amp; style...</option>
							<?php
								$this->load_google_font_options( 'styles', get_option( 'heading_4_font_styles' ) );
							?>
						</select>
						&nbsp;&nbsp;&nbsp;
						(h4, .h4, .display-4)
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label>
							Heading 5
						</label>
					</th>
					<td>
						<select name="heading_5_font_typeface">
							<option value="">Select typeface...</option>
							<?php
								$this->load_google_font_options( 'typeface', get_option( 'heading_5_font_typeface' ) );
							?>
						</select>
						&nbsp;&nbsp;&nbsp;
						<select name="heading_5_font_styles">
							<option value="">Select weight &amp; style...</option>
							<?php
								$this->load_google_font_options( 'styles', get_option( 'heading_5_font_styles' ) );
							?>
						</select>
						&nbsp;&nbsp;&nbsp;
						(h5, .h5)
					</td>
				</tr>
				<tr>
					<th scope="row">
						<label>
							Heading 6
						</label>
					</th>
					<td>
						<select name="heading_6_font_typeface">
							<option value="">Select typeface...</option>
							<?php
								$this->load_google_font_options( 'typeface', get_option( 'heading_6_font_typeface' ) );
							?>
						</select>
						&nbsp;&nbsp;&nbsp;
						<select name="heading_6_font_styles">
							<option value="">Select weight &amp; style...</option>
							<?php
								$this->load_google_font_options( 'styles', get_option( 'heading_6_font_styles' ) );
							?>
						</select>
						&nbsp;&nbsp;&nbsp;
						(h6, .h6)
					</td>
				</tr>
			</tbody>
		</table>
		
		<p class="submit">
			<input type="submit" name="Submit" class="button-primary" value="<?php esc_attr_e('Save Changes'); ?>" />
			&nbsp;&nbsp;&nbsp;
			<?php if ( $msg ) : print '<em class="text-success">' . $msg . '</em>'; endif; ?>
		</p>
	</form>
<?php
		print '</div></div></div>';

	}

	/**
	 * Cloning is forbidden.
	 */
	private function __clone() { }

	/**
	 * Unserializing instances of this class is forbidden.
	 */
	private function __wakeup() { }
}

endif;

Developry_Google_Fonts::instance();
