<?php

/**
* Display the page where the slugs could be regenerated or replaced
*/
class Permalink_Manager_Debug extends Permalink_Manager_Class {

	public function __construct() {
		add_filter( 'permalink_manager_sections', array($this, 'add_debug_section'), 4 );
	}

	public function add_debug_section($admin_sections) {
		$admin_sections['debug'] = array(
			'name'				=>	__('Debug', 'permalink-manager'),
			'function'    => array('class' => 'Permalink_Manager_Debug', 'method' => 'output')
		);

		return $admin_sections;
	}

	public function output() {
		global $permalink_manager_options, $permalink_manager_uris, $permalink_manager_permastructs, $permalink_manager_redirects, $wp_filter;

		$sections_and_fields = apply_filters('permalink_manager_debug_fields', array(
			'debug-data' => array(
				'section_name' => __('Debug data', 'permalink-manager'),
				'fields' => array(
					'uris' => array(
						'type' => 'textarea',
						'description' => __('List of the URIs generated by this plugin.', 'permalink-manager'),
						'label' => __('Array with URIs', 'permalink-manager'),
						'input_class' => 'short-textarea widefat',
						'value' => ($permalink_manager_uris) ? print_r($permalink_manager_uris, true) : ''
					),
					'custom-redirects' => array(
						'type' => 'textarea',
						'description' => __('List of custom redirects set-up by this plugin.', 'permalink-manager'),
						'label' => __('Array with redirects', 'permalink-manager'),
						'input_class' => 'short-textarea widefat',
						'value' => ($permalink_manager_redirects) ? print_r($permalink_manager_redirects, true) : ''
					),
					'permastructs' => array(
						'type' => 'textarea',
						'description' => __('List of the permastructures.', 'permalink-manager'),
						'label' => __('Array with permastructures', 'permalink-manager'),
						'input_class' => 'short-textarea widefat',
						'value' => ($permalink_manager_permastructs) ? print_r($permalink_manager_permastructs, true) : ''
					),
					'settings' => array(
						'type' => 'textarea',
						'description' => __('Currently used plugin settings.', 'permalink-manager'),
						'label' => __('Array with settings used in this plugin.', 'permalink-manager'),
						'input_class' => 'short-textarea widefat',
						'value' => print_r($permalink_manager_options, true)
					)
				)
			)
		));

		// Now get the HTML output
		$output = '';
		foreach($sections_and_fields as $section_id => $section) {
			$output .= (isset($section['section_name'])) ? "<h3>{$section['section_name']}</h3>" : "";
			$output .= (isset($section['description'])) ? "<p class=\"description\">{$section['description']}</p>" : "";
			$output .= "<table class=\"form-table fixed-table\">";

			// Loop through all fields assigned to this section
			foreach($section['fields'] as $field_id => $field) {
				$field_name = "{$section_id}[$field_id]";
				$field['container'] = 'row';

				$output .= Permalink_Manager_Admin_Functions::generate_option_field($field_name, $field);
			}

			// End the section
			$output .= "</table>";

		}

		return $output;
	}

}
