# Features
* Added functionality to allow the same term name across multiple languages without the use of @lang suffixes
* Added functionality to remove existing language suffixes to the troubleshooting menu
* Added support for translation of string packages
* Added template tag to display HTML input with current language wpml_the_language_input_field()
* Button "Post type assignments" added to Troubleshooting page allowing to synchronise post types and languages in translation table
* Installer: Added pagination for site keys list of Account -> My Sites
* Installer: Allow registering new sites by clicking a link in the WordPress admin instead of copying and pasting the site url in the Account -> My Sites section
* Installer: Display more detailed debug information related to connectivity issues with the WPML repository
* Minor speed and compatibility improvement: JS files are now called from footer
* Minor speed improvements related to operations on arrays
* Minor speed improvements related to string caching

# Fixes
* Fix for conflicting values of context when registering strings for translation
* Fixed category setting for Woocommerce products
* Fixed custom queries while using a root page
* Fixed DB error when fetching completed translations from ICanLocalize
* Fixed influence of admin language on settings for language switcher in menu
* Fixed issue with caching on page set as front page
* Fixed language filters for get_terms() function
* Fixed minor issues in wp-admin with RTL languages
* Fixed missing terms filtering by current language in admin panel
* Fixed pagination on root page
* Fixed problem with adding categories by simply pressing "Enter" key (post edit screen)
* Fixed problem with comments quick edit
* Fixed problem with editing post slug
* Fixed problem with language switcher options during installation
* Fixed problem with taxonomy (e.g. category) parents synchronization
* Fixed root page permalink on post edit screen
* Fixed root page preview
* Fixed search form on secondary language
* Fixed some PHP notices and warnings
* Fixed some PHP notices on WPML Languages page with "All Languages" selected on language switcher
* Fixed: Archive of untranslated custom post type should not display 'rel="alternate" hreflang="" href=""' in header
* Fixed: Taxonomy terms are not showing on the WPML->Taxonomy Translation page
* icl_object_id function now works well also with unregistered custom post types
* Installer: Fixed problem with WPML registration information (site key) not being saved when the option_value field in the wp_options table used a different charset than the default WordPress charset defined in wp-config.php
* Installer: Reversed the order in which the site keys are displayed
* Minor issues with language switcher on mobile devices
* Removed option to delete default category translations
* Removed unnecessary taxonomy selector from Taxonomy translation page
* Textarea for additional CSS for language switcher was too wide, now it fits into screen
* wp_nav_menu now always displays language switcher when configured