<?php

/**
 * CobrosYA Creditel Payment Gateway
 *
 * @class        WC_Gateway_CobrosYA_Creditel
 * @extends      WC_Payment_Gateway
 * @version      5.0.0
 * @author       Gabriel Badano
 */
class WC_Gateway_CobrosYA_Creditel extends WC_Payment_Gateway {

    public $medio_id          = 15;
    public $medio_descripcion = "Creditel";
    public $medio_code        = "cyacreditel";

    /**
     * Constructor for the gateway.
     */
    public function __construct() {

        $this->has_fields = true;

        woocommerce_gateway_CobrosYA_construct($this);

        $this->cuotas = $this->get_option('cuotas');

        if ($this->enabled == 'no')
            return;

        add_action('woocommerce_api_wc_gateway_cobrosya', array($this, 'check_response'));

        add_filter('woocommerce_checkout_fields', 'woocommerce_gateway_CobrosYA_checkout_fields');
        add_action('woocommerce_checkout_update_order_meta', 'woocommerce_gateway_CobrosYA_update_fields' );
        add_action('woocommerce_admin_order_data_after_billing_address', 'woocommerce_gateway_CobrosYA_admin_fields', 10, 1);

    }

    public function payment_fields() {

        parent::payment_fields();

        woocommerce_gateway_CobrosYA_display_cuotas($this);

    }

    /**
     * Initialise Gateway Settings Form Fields
     */
    public function init_form_fields() {

        woocommerce_gateway_CobrosYA_init_form_fields($this, "T", null, true);

    }

    /**
     * Process the payment and return the result
     *
     * @param int $order_id
     * @return array
     */
    public function process_payment($order_id) {

        return woocommerce_gateway_CobrosYA_process_payment($order_id, $this, true);

    }

    /**
     * Return handler for Hosted Payments
     */
    public function check_response() {

        woocommerce_gateway_CobrosYA_check_response($this);

    }

}