<?php

function woocommerce_gateway_CobrosYA_install() {

    global $wpdb;

    $wpdb->query('SHOW TABLES LIKE "'.$wpdb->prefix.'cobrosya_talones"');

    if ($wpdb->num_rows <= 0) {

        $wpdb->query('CREATE TABLE IF NOT EXISTS '.$wpdb->prefix.'cobrosya_talones (
                order_id bigint(20) unsigned NOT NULL DEFAULT "0",
                nro_talon bigint(20) unsigned NOT NULL DEFAULT "0",
                url_pdf varchar(100) NOT NULL DEFAULT "",
                fecha_vencimiento date DEFAULT NULL,
                paga tinyint(1) NOT NULL DEFAULT "0",
                PRIMARY KEY (order_id),
                UNIQUE KEY nro_talon (nro_talon)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8'
        );

    }

    $wpdb->query('SHOW TABLES LIKE "'.$wpdb->prefix.'cobrosya_clientes"');

    if ($wpdb->num_rows <= 0) {

        $wpdb->query('CREATE TABLE IF NOT EXISTS '.$wpdb->prefix.'cobrosya_clientes (
                user_id bigint(20) unsigned NOT NULL DEFAULT "0",
                id_cliente_cobrosya varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                PRIMARY KEY (user_id),
                UNIQUE KEY id_cliente_cobrosya (id_cliente_cobrosya)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8'
        );

    }

    $wpdb->query('SHOW TABLES LIKE "'.$wpdb->prefix.'cobrosya_sandbox_talones"');

    if ($wpdb->num_rows <= 0) {

        $wpdb->query('CREATE TABLE IF NOT EXISTS '.$wpdb->prefix.'cobrosya_sandbox_talones (
                order_id bigint(20) unsigned NOT NULL DEFAULT "0",
                nro_talon bigint(20) unsigned NOT NULL DEFAULT "0",
                url_pdf varchar(100) NOT NULL DEFAULT "",
                fecha_vencimiento date DEFAULT NULL,
                paga tinyint(1) NOT NULL DEFAULT "0",
                PRIMARY KEY (order_id),
                UNIQUE KEY nro_talon (nro_talon)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8'
        );

    }

    $wpdb->query('SHOW TABLES LIKE "'.$wpdb->prefix.'cobrosya_sandbox_clientes"');

    if ($wpdb->num_rows <= 0) {

        $wpdb->query('CREATE TABLE IF NOT EXISTS '.$wpdb->prefix.'cobrosya_sandbox_clientes (
                user_id bigint(20) unsigned NOT NULL DEFAULT "0",
                id_cliente_cobrosya varchar(36) COLLATE utf8_unicode_ci NOT NULL,
                PRIMARY KEY (user_id),
                UNIQUE KEY id_cliente_cobrosya (id_cliente_cobrosya)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8'
        );

    }

}

function woocommerce_gateway_CobrosYA_init_form_fields($gtw, $tipo, $dias = null, $cuotas = false) {

    $gtw->form_fields = array(
        'enabled' => array(
            'title' => __('Enable/Disable', 'woocommerce'),
            'type' => 'checkbox',
            'label' => __('Habilitar CobrosYA '.$gtw->medio_descripcion, 'woocommerce'),
            'default' => 'no'
        ),
        'description' => array(
            'title' => __('Description', 'woocommerce'),
            'type' => 'textarea',
            'description' => __('Descripción que se muestra al usuario durante el proceso de pago', 'woocommerce'),
            'default' => __('Pague online con '.$gtw->medio_descripcion . ' al finalizar su compra', 'woocommerce'),
            'desc_tip' => true,
        )
    );

    if ($dias != null)

        $gtw->form_fields['dias_vencimiento'] = array(
            'title' => 'Límite de Pago',
            'type' => 'select',
            'options' => $dias,
            'description' => 'Cantidad de días que permite pagar en '.$gtw->medio_descripcion,
            'desc_tip' => true,
        );

    if ($cuotas)

        $gtw->form_fields['cuotas'] = array(
            'title' => 'Planes de cuotas',
            'type' => 'text',
            'description' => 'Planes de cuotas separados por comas. Por ejemplo 1,3,6 para planes contado, 3 y 6 cuotas. Debe estar autorizado por la tarjeta.',
            'desc_tip' => true,
        );

    $gtw->form_fields['notify_url'] = array(
        'title' => 'IMPORTANTE!!! URL de Notificación de CobrosYA',
        'type' => 'title',
        'description' => 'Para poder recibir información del resultado de las transacciones, debe ingresar esta URL de Notificaciones en su cuenta de CobrosYA, en el menu Cuenta/Configuración:<br/><b>'.WC()->api_request_url('WC_Gateway_CobrosYA').'</b>',
    );

}

function woocommerce_gateway_CobrosYA_process_payment($order_id, $gtw, $usaCuotas = false) {

    global $wpdb;

    $user = wp_get_current_user();

    if ($idClienteCobrosya = woocommerce_gateway_CobrosYA_registrar_cliente($gtw, $user)) {

        $order = wc_get_order($order_id);

        $xml = woocommerce_gateway_CobrosYA_createTransaction($order, $gtw, $idClienteCobrosya);

        $xmlArr = json_decode(json_encode($xml), true);

        if ($xmlArr["error"] == 0)
            $nro_talon = $xmlArr["nro_talon"];

        if (isset($nro_talon)) {

            $idTarjeta = isset($_POST[$gtw->medio_code . "-tarjeta"]) ? $_POST[$gtw->medio_code . "-tarjeta"] : 0;

            if ($idTarjeta != "0") {

                $param = array(
                    'token'               => woocommerce_gateway_CobrosYA_get_token(),
                    'id_cliente_cobrosya' => $idClienteCobrosya,
                    'id_tarjeta'          => $idTarjeta,
                    'nro_talon'           => $nro_talon,
                    'id_medio_pago'       => $gtw->medio_id
                );

                $cuotas = isset($_POST[$gtw->medio_code . "-cuotas"]) ? max(intval($_POST[$gtw->medio_code . "-cuotas"]), 1) : 1;

                if ($usaCuotas)
                    $param['cuotas'] = $cuotas;

                $param['firma'] = woocommerce_gateway_CobrosYA_firmar($param);

                if (isset($_POST[$gtw->medio_code . "-cvv2"]))
                    $param['cvv2'] = $_POST[$gtw->medio_code . "-cvv2"];

                $xmlCobrar    = woocommerce_gateway_CobrosYA_connect("ws-cobrar-talon", $param);
                $xmlCobrarArr = json_decode(json_encode($xmlCobrar), true);

                if (isset($xmlCobrarArr["error"]) and $xmlCobrarArr["error"] == 0) {

                    $wpdb->update(
                        woocommerce_gateway_CobrosYA_get_tabla_talones(),
                        array('paga'     => 1),
                        array('order_id' => $order_id),
                        array('%s')
                    );

                    $order->update_status('pending');

                    $note = sprintf(__('CobrosYA '.$gtw->medio_descripcion.' %s pago aprobado. Talón: %s', 'woocommerce'), woocommerce_gateway_CobrosYA_cuotasTexto($cuotas), $nro_talon);

                    if (isset($xmlCobrarArr["autorizacion"]))
                        $note = sprintf(__($note.'. Autorizacion %s', 'woocommerce'), $xmlCobrarArr["autorizacion"]);

                    // Add order note
                    $order->add_order_note($note);

                    // Payment complete
                    $order->payment_complete($nro_talon);

                    // Remove cart
                    WC()->cart->empty_cart();

                    return array(
                        'result' => 'success',
                        'redirect' => $gtw->get_return_url($order)
                    );

                }else{

                    $order->update_status('failed');

                    $order->add_order_note(sprintf(__('CobrosYA '.$gtw->medio_descripcion.' pago rechazado. Talon: %s. Mensaje: %s', 'woocommerce' ), $nro_talon, $xmlCobrarArr["error_descripcion"]));

                    wc_add_notice( __('Error en el pago: ', 'woothemes') . $xmlCobrarArr["error_descripcion"], 'error' );

                    return;

                }

            }else{

                if ($usaCuotas) {

                    $cuotas = isset($_POST[$gtw->medio_code . "-cuotas"]) ? max(intval($_POST[$gtw->medio_code . "-cuotas"]), 1) : 1;

                    // Redirect to CobrosYA
                    return array(
                        'result' => 'success',
                        'redirect' => woocommerce_gateway_CobrosYA_getCobrarUrl($gtw, $nro_talon, $gtw->medio_id, $cuotas)
                    );

                }else{

                    // Redirect to CobrosYA
                    return array(
                        'result' => 'success',
                        'redirect' => woocommerce_gateway_CobrosYA_getCobrarUrl($gtw, $nro_talon, $gtw->medio_id)
                    );

                }

            }

        }

    }

    return false;

}

function woocommerce_gateway_CobrosYA_createTransaction($order, $gtw, $idClienteCobrosya, $conVencimiento = false) {

    global $wpdb;

    $taxes = $order->get_taxes();

    $iva = 0;
    foreach ($taxes as $tax)
        $iva += $tax["tax_amount"];

    $data = array(
        "token"               => woocommerce_gateway_CobrosYA_get_token(),
        "id_cliente_cobrosya" => $idClienteCobrosya,
        "id_transaccion"      => $order->id,
        "nombre"              => $order->billing_first_name,
        "apellido"            => $order->billing_last_name,
        "email"               => $order->billing_email,
        "moneda"              => CYA_MONEDA,
        "monto"               => $order->order_total,
        "url_respuesta"       => $gtw->get_return_url($order)
    );

    $data['firma'] = woocommerce_gateway_CobrosYA_firmar($data);

    $data["concepto"]      = "Orden de compra #".$order->id;
    $data["consumo_final"] = get_post_meta($order->id, 'billing_consumo_final', true);
    $data["factura"]       = $order->id;
    $data["monto_gravado"] = ($iva == 0 ? 0 : ($order->order_total - $iva));

    if (!empty($order->billing_phone) and preg_match('/^09[0‐9]{7}$/', $order->billing_phone))
        $data["celular"] = $order->billing_phone;

    if ($conVencimiento and $gtw->dias_vencimiento == intval($gtw->dias_vencimiento) and $gtw->dias_vencimiento > 0) {
        $fecha = new DateTime();
        $fecha->add(DateInterval::createFromDateString($gtw->dias_vencimiento.' day'));
        $fecha = $fecha->format("Y-m-d");
        $data["fecha_vencimiento"] = $fecha;
    }

    $xml = woocommerce_gateway_CobrosYA_connect("ws-crear-talon", $data);

    if (isset($xml->error) and $xml->error == 0) {

        if (isset($xml->mediosdepago)) {

            $medios = explode(",", $xml->mediosdepago);

            $habilitado = false;
            foreach ($medios as $medio) {
                if ($medio == $gtw->medio_id) {
                    $habilitado = true;
                    break;
                }
            }

            if ($habilitado) {

                $wpdb->insert(woocommerce_gateway_CobrosYA_get_tabla_talones(), array(
                    'order_id'          => $order->id,
                    'nro_talon'         => $xml->nro_talon,
                    'url_pdf'           => $xml->url_pdf,
                    'fecha_vencimiento' => isset($fecha) ? $fecha : null
                ));

            }else{

                wc_add_notice($gtw->medio_descripcion.' no se encuentra habilitado para esta transacción', 'error');

                $xml->error = 99;

            }

        }

    }else{

        wc_add_notice('Error código '.$xml->error.' Problemas al pagar por CobrosYa', 'error');

    }

    return $xml;

}

function woocommerce_gateway_CobrosYA_getCobrarUrl($gtw, $nro_talon, $medio_id, $cuotas = null) {

    $param = array(
        "nro_talon"     => (int) $nro_talon,    // le tuve que poner (int) para que andara
        "id_medio_pago" => $medio_id
    );

    if ($cuotas != null)
        $param["cuotas"] = $cuotas;

    $param["firma"] = woocommerce_gateway_CobrosYA_firmar($param);

    return woocommerce_gateway_CobrosYA_get_api_url("cobrar-talon") . "?" . http_build_query($param);

}

function woocommerce_gateway_CobrosYA_construct($gtw) {

    $gtw->id                 = $gtw->medio_code;
    $gtw->icon               = apply_filters('woocommerce_CobrosYA_'.$gtw->medio_descripcion.'_icon', plugins_url('/cobrosya/images/' . $gtw->medio_id . '.png'));
    $gtw->has_fields         = false;
    $gtw->method_title       = __($gtw->medio_descripcion, 'woocommerce');
    $gtw->method_description = __('Permite procesar pagos con '.$gtw->medio_descripcion.' a través de CobrosYA.com', 'woocommerce');
    $gtw->enabled            = $gtw->get_option('enabled');

    // Load the settings.
    $gtw->init_form_fields();
    $gtw->init_settings();

    // Define user set variables
    $gtw->title       = $gtw->medio_descripcion;
    $gtw->description = $gtw->get_option('description');

    if ($gtw->medio_code == 'cyaredpagos')
        $gtw->dias_vencimiento = $gtw->get_option('dias_vencimiento');

    $gtw->notify_url = $gtw->get_option('notify_url');

    if (version_compare(WOOCOMMERCE_VERSION, '2.0.0', '>=')) {
        add_action('woocommerce_update_options_payment_gateways_' . $gtw->id, array(&$gtw, 'process_admin_options'));
    }else{
        add_action('woocommerce_update_options_payment_gateways', array(&$gtw, 'process_admin_options'));
    }

}

function woocommerce_gateway_CobrosYA_check_response($gtw) {

    global $wpdb;

    woocommerce_gateway_CobrosYA_log(print_r($_POST, true), "N");

    @ob_clean();
    header('HTTP/1.1 200 OK');

    if (isset($_POST['accion']) and isset($_POST['firma'])) {

        $param = array(
            'accion'          => $_POST["accion"],
            'nro_talon'       => $_POST["nro_talon"],
            'id_medio_pago'   => $_POST["id_medio_pago"],
            'medio_pago'      => $_POST["medio_pago"],
            'moneda'          => $_POST["moneda"],
            'monto'           => $_POST["monto"]
        );

        if (woocommerce_gateway_CobrosYA_verificar_firma($_POST["firma"], $param)) {

            $nro_talon = intval($_POST['nro_talon']);

            $cya = $wpdb->get_row($wpdb->prepare('SELECT * FROM '.woocommerce_gateway_CobrosYA_get_tabla_talones().' WHERE nro_talon = %s',
                $nro_talon
            ));

            if ($cya->nro_talon == $nro_talon) {

                $accion = $_POST['accion'];

                if ($accion == "cobro") {

                    $wpdb->update(
                        woocommerce_gateway_CobrosYA_get_tabla_talones(),
                        array('paga'     => 1),
                        array('order_id' => $cya->order_id),
                        array('%s')
                    );

                    $order = wc_get_order($cya->order_id);

                    $order->update_status('pending');

                    if (isset($_POST["cuotas_texto"]))
                        $note = sprintf(__('CobrosYA '.$_POST["medio_pago"].' %s pago aprobado. Talón: %s', 'woocommerce'), ($_POST["cuotas_codigo"] == 0 ? "Cuotas: " : "") . $_POST["cuotas_texto"], $cya->nro_talon);
                    else
                        $note = sprintf(__('CobrosYA '.$_POST["medio_pago"].' pago aprobado. Talón: %s', 'woocommerce'), $cya->nro_talon);

                    if (isset($_POST["autorizacion"]))
                        $note = sprintf(__($note.'. Autorizacion %s', 'woocommerce'), $_POST["autorizacion"]);

                    // Add order note
                    $order->add_order_note($note);

                    // Payment complete
                    $order->payment_complete($cya->nro_talon);

                    // Remove cart
                    WC()->cart->empty_cart();

                    echo "1";

                }elseif ($accion == "rechazo") {

                    $order = wc_get_order($cya->order_id);

                    $order->update_status('failed');

                    $order->add_order_note(sprintf(__('CobrosYA '.$_POST["medio_pago"].' pago rechazado. Talon: %s. Mensaje: %s', 'woocommerce' ), $cya->nro_talon, $_POST["mensaje"]));

                    echo "1";

                }

            }

        }else{

            woocommerce_gateway_CobrosYA_log("Error no verifica firma", "N");

        }

    }

    exit();

}

function woocommerce_gateway_CobrosYA_checkout_fields( $fields ) {

    $fields['billing']['billing_consumo_final'] = array(
        'label'     => __('Consumo final o RUT', 'woocommerce'),
        'placeholder'   => _x('Consumo final o RUT', 'placeholder', 'woocommerce'),
        'required'  => true,
        'class'     => array('form-row-wide'),
        'clear'     => true,
        'type'      => 'select',
        'options'   => array(
            1 => 'Consumo final',
            0 => 'RUT'
        ),
    );

    $fields['billing']['billing_rut'] = array(
        'label'     => __('RUT', 'woocommerce'),
        'required'  => false,
        'class'     => array('form-row-wide'),
        'clear'     => true,
    );

    $fields['billing']['billing_razon_social'] = array(
        'label'     => __('Razón Social', 'woocommerce'),
        'required'  => false,
        'class'     => array('form-row-wide'),
        'clear'     => true,
    );

    return $fields;

}

function woocommerce_gateway_CobrosYA_update_fields($order_id) {

    if (!empty($_POST['billing_consumo_final']))
        update_post_meta($order_id, 'billing_consumo_final', $_POST['billing_consumo_final']);

    if (!empty($_POST['billing_rut']))
        update_post_meta($order_id, 'billing_rut', $_POST['billing_rut']);

    if (!empty($_POST['billing_razon_social']))
        update_post_meta($order_id, 'billing_razon_social', $_POST['billing_razon_social']);

}

function woocommerce_gateway_CobrosYA_admin_fields($order) {

    $consumoFinal = get_post_meta($order->id, 'billing_consumo_final', true);

    echo '<p><strong>Datos adicionales para facturación</strong><br/>';

    echo ($consumoFinal == 1 ? 'Consumo final' : 'RUT') . '<br/>';

    if ($consumoFinal != 1) {
        echo get_post_meta($order->id, 'billing_rut', true) . '<br/>';
        echo get_post_meta($order->id, 'billing_razon_social', true) . '<br/>';
    }

    echo '</p>';

}

function woocommerce_gateway_CobrosYA_display_cuotas($gtw) {

    $cuotas = explode(",", $gtw->cuotas);

    echo '<p class="form-row form-row-wide plan_cuotas '.$gtw->medio_code.'-cuotas"><label for="'.$gtw->medio_code.'-cuotas">Plan de cuotas</label><select name="'.$gtw->medio_code.'-cuotas">';

    $alMenosUna = false;

    foreach ($cuotas as $cuota) {

        if ($cuota == intval($cuota) and $cuota > 0) {

            if ($cuota == 1)
                echo '<option value="' . $cuota . '">Contado</option>';
            else
                echo '<option value="' . $cuota . '">' . $cuota . ' cuotas</option>';

            $alMenosUna = true;

        }

    }

    if (!$alMenosUna)
        echo '<option value="1">Contado</option>';

    echo '</select></p>';

}

function woocommerce_gateway_CobrosYA_display_fields($gtw, $mostrarCuotas = false) {

    if (is_user_logged_in()) {

        $user = wp_get_current_user();

        if ($idClienteCobrosya = woocommerce_gateway_CobrosYA_registrar_cliente($gtw, $user)) {

            $param = array(
                'token'               => woocommerce_gateway_CobrosYA_get_token(),
                'id_cliente_cobrosya' => $idClienteCobrosya,
                'moneda'              => CYA_MONEDA
            );

            $param['firma']         = woocommerce_gateway_CobrosYA_firmar($param);
            $param['id_medio_pago'] = $gtw->medio_id;

            $result = woocommerce_gateway_CobrosYA_connect("ws-medios-de-pago", $param);

            $xmlObj = json_decode(json_encode($result), true);

            $muestroTarjetas = false;

            if (isset($xmlObj["error"]) and $xmlObj["error"] == 0) {

                $medio = $xmlObj["mediosdepago"]["mediodepago_" . $gtw->medio_id];

                if ($medio["tipo"] == 3) {

                    $tarjetas = $medio["tarjetas"];

                    foreach ($tarjetas as $k => $t) {

                        if (!is_numeric($k)) {

                            if ($medio["permite_cuotas"] == 2)
                                $permiteCuotas = $t["permite_cuotas"];
                            else
                                $permiteCuotas = $medio["permite_cuotas"];

                            echo '<p><label for="' . $gtw->medio_code . '-tarjeta_' . $t["id_tarjeta"] . '"><input type="radio" name="' . $gtw->medio_code . '-tarjeta" data-cuotas="' . $permiteCuotas . '" data-cvv="' . $medio["pedir_cvv2"] . '" value="' . $t["id_tarjeta"] . '" class="cobrosya_' . $gtw->medio_code . '_tarjeta" />XXXX-XXXX-XXXX-' . $t["digitos"] . ' vence: ' . substr($t["vencimiento"], 4) . '/' . substr($t["vencimiento"], 0, 4) . '</label></p>';

                            $muestroTarjetas = true;

                        }

                    }

                    if ($muestroTarjetas)
                        echo '<p><label for="' . $gtw->medio_code . '-tarjeta_nueva"><input type="radio" name="' . $gtw->medio_code . '-tarjeta" data-cuotas="' . ($medio["permite_cuotas"] == 2 ? 0 : $medio["permite_cuotas"]) . '" value="0" class="cobrosya_' . $gtw->medio_code . '_tarjeta" checked="checked" />Agregar tarjeta...</label></p>';

                }

                if ($mostrarCuotas or $medio["permite_cuotas"] == 1 or ($medio["permite_cuotas"] == 2 and $muestroTarjetas) or $medio["tipo"] == 3)
                    woocommerce_gateway_CobrosYA_display_cuotas($gtw);

                if ($medio["pedir_cvv2"] and $muestroTarjetas)
                    echo '<p class="form-row form-row-first cobrosya_cvv2 ' . $gtw->medio_code . '-cvv2"><label for="' . $gtw->medio_code . '-cvv2">Código seguridad</label><input type="text" name="' . $gtw->medio_code . '-cvv2" /></p>';

                echo '<div class="clear"></div>';

                if ($medio["tipo"] == 3 and $muestroTarjetas)
                    echo '<script>jQuery("input.cobrosya_' . $gtw->medio_code . '_tarjeta").on("click", function(){ if (jQuery(this).attr("data-cuotas") == 1) jQuery(".'.$gtw->medio_code.'-cuotas").show(); else jQuery(".'.$gtw->medio_code.'-cuotas").hide(); if (jQuery(this).attr("data-cvv") == 1) jQuery(".'.$gtw->medio_code.'-cvv2").show(); else jQuery(".'.$gtw->medio_code.'-cvv2").hide(); }); jQuery("input.cobrosya_' . $gtw->medio_code . '_tarjeta:checked").click();jQuery(".payment_box.payment_method_' . $gtw->medio_code . '").hide();jQuery("input#payment_method_' . $gtw->medio_code . '").prop("checked", false);</script>';

            }

        }elseif ($gtw->medio_id == 12) {

            woocommerce_gateway_CobrosYA_display_cuotas($gtw);

        }

    }elseif ($gtw->medio_id == 12) {

        woocommerce_gateway_CobrosYA_display_cuotas($gtw);

    }

}

function woocommerce_gateway_CobrosYA_get_id_cliente_cobrosya($user) {

    global $wpdb;

    $cyaCliente = $wpdb->get_row($wpdb->prepare('SELECT * FROM ' . woocommerce_gateway_CobrosYA_get_tabla_clientes() . ' WHERE user_id = %s',
        $user->ID
    ));

    if ($cyaCliente->user_id == $user->ID)
        return $cyaCliente->id_cliente_cobrosya;
    else
        return false;

}

function woocommerce_gateway_CobrosYA_registrar_cliente($gtw, $user) {

    global $wpdb;

    if ($idClienteCobrosYA = woocommerce_gateway_CobrosYA_get_id_cliente_cobrosya($user)) {

        return $idClienteCobrosYA;

    }else{

        $param = array(
            'token'               => woocommerce_gateway_CobrosYA_get_token(),
            'id_cliente_comercio' => $user->ID,
            'nombre'              => $user->first_name,
            'apellido'            => $user->last_name,
            'email'               => $user->user_email
        );

        $param['firma'] = woocommerce_gateway_CobrosYA_firmar($param);

        $xmlObj = woocommerce_gateway_CobrosYA_connect("ws-registrar-cliente", $param);

        if (isset($xmlObj->error) and $xmlObj->error == 0) {

            $wpdb->insert(woocommerce_gateway_CobrosYA_get_tabla_clientes(), array(
                'user_id'             => $user->ID,
                'id_cliente_cobrosya' => (string)$xmlObj->id_cliente_cobrosya
            ));

            return (string)$xmlObj->id_cliente_cobrosya;

        }else{

            return false;

        }

    }

}

function woocommerce_gateway_CobrosYA_firmar($param) {

    $data = implode($param);

    $pKey = openssl_pkey_get_private(woocommerce_gateway_CobrosYA_get_llave_privada());

    if (openssl_sign($data, $firma, $pKey))
        return base64_encode($firma);

    return false;

}

function woocommerce_gateway_CobrosYA_verificar_firma($firma, $param) {

    $data = implode($param);

    $pKey = openssl_pkey_get_public(woocommerce_gateway_CobrosYA_get_llave_publica());

    return openssl_verify($data, base64_decode($firma), $pKey);

}

function woocommerce_gateway_CobrosYA_get_api_url($metodo) {

    return (CYA_SANDBOX == 1 ? "http://api-sandbox5.cobrosya.com/v5/" : "https://api.cobrosya.com/v5/") . $metodo;

}

function woocommerce_gateway_CobrosYA_get_token() {

    return CYA_TOKEN;

}

function woocommerce_gateway_CobrosYA_get_llave_privada() {

    return file_get_contents(__DIR__ . "/.." . CYA_LLAVE_PRIVADA);

}

function woocommerce_gateway_CobrosYA_get_llave_publica() {

    return file_get_contents(__DIR__ . "/.." . CYA_LLAVE_PUBLICA);

}

function woocommerce_gateway_CobrosYA_get_tabla_talones() {

    global $wpdb;

    if (CYA_SANDBOX == 1)
        return $wpdb->prefix.'cobrosya_sandbox_talones';
    else
        return $wpdb->prefix.'cobrosya_talones';

}

function woocommerce_gateway_CobrosYA_get_tabla_clientes() {

    global $wpdb;

    if (CYA_SANDBOX == 1)
        return $wpdb->prefix.'cobrosya_sandbox_clientes';
    else
        return $wpdb->prefix.'cobrosya_clientes';

}

function woocommerce_gateway_CobrosYA_connect($metodo, $data) {

    $ch = curl_init(woocommerce_gateway_CobrosYA_get_api_url($metodo));

    curl_setopt($ch, CURLOPT_HEADER, 0);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
    curl_setopt($ch, CURLOPT_USERAGENT, "Woocommerce CobrosYA Plugin API 5");
    curl_setopt($ch, CURLOPT_AUTOREFERER, 1);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 120);
    curl_setopt($ch, CURLOPT_TIMEOUT, 120);
    curl_setopt($ch, CURLOPT_MAXREDIRS, 10);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_VERBOSE, true);

    $res = curl_exec($ch);

    curl_close($ch);

    woocommerce_gateway_CobrosYA_log(woocommerce_gateway_CobrosYA_get_api_url($metodo) . " - " . print_r($data, true) . "\r\n" . $res);

    return simplexml_load_string($res);

}

function woocommerce_gateway_CobrosYA_cuotasTexto($cuotas) {

    if ($cuotas == 1)
        return "Contado";
    else
        return $cuotas . " cuotas";

}

function woocommerce_gateway_CobrosYA_log($texto, $tipo = "A" ) {

    if (CYA_HABILITAR_LOGS) {

        if ($tipo == "N")
            file_put_contents(plugin_dir_path(__FILE__) . "../logs/notificaciones.log", date("Y-m-d H:i:s") . " - " . $texto . "\r\n", FILE_APPEND);
        else
            file_put_contents(plugin_dir_path(__FILE__) . "../logs/apiclient.log", date("Y-m-d H:i:s") . " - " . $texto . "\r\n", FILE_APPEND);

    }

}
