<?php

/**
 * CobrosYA Redpagos Payment Gateway
 *
 * @class        WC_Gateway_CobrosYA
 * @extends      WC_Payment_Gateway
 * @version      5.0.0
 * @author       Gabriel Badano
 */
class WC_Gateway_CobrosYA extends WC_Payment_Gateway {

    public $medio_id          = 6;
    public $medio_descripcion = "Redpagos";
    public $medio_code        = "cyaredpagos";

    /**
     * Constructor for the gateway.
     */
    public function __construct() {

        woocommerce_gateway_CobrosYA_construct($this);

        if ($this->enabled == 'no')
            return;

        add_action('woocommerce_api_wc_gateway_cobrosya', array($this, 'check_response'));

        add_action('woocommerce_thankyou_cyaredpagos', array($this, 'thankyou_page'));

        add_action('woocommerce_email_before_order_table', array($this, 'email_instructions'), 10, 3);

        add_filter('woocommerce_checkout_fields', 'woocommerce_gateway_CobrosYA_checkout_fields');
        add_action('woocommerce_checkout_update_order_meta', 'woocommerce_gateway_CobrosYA_update_fields' );
        add_action('woocommerce_admin_order_data_after_billing_address', 'woocommerce_gateway_CobrosYA_admin_fields', 10, 1);

    }

    /**
     * Initialise Gateway Settings Form Fields
     */
    public function init_form_fields() {

        $dias = array(0 => "Sin límite de pago");
        for ($n = 1; $n <= 30; $n++)
            $dias[$n] = $n." días";

        woocommerce_gateway_CobrosYA_init_form_fields($this, "R", $dias);

    }

    /**
     * Process the payment and return the result
     *
     * @param int $order_id
     * @return array
     */
    public function process_payment($order_id) {

        $user = wp_get_current_user();

        if ($idClienteCobrosya = woocommerce_gateway_CobrosYA_registrar_cliente($this, $user)) {

            $order = wc_get_order($order_id);

            $xml = woocommerce_gateway_CobrosYA_createTransaction($order, $this, $idClienteCobrosya, true);

            if (isset($xml->error) and $xml->error == 0) {

                // Reduce stock levels
                $order->reduce_order_stock();

                // Mark as on-hold (we're awaiting the cheque)
                $order->update_status('on-hold', __(sprintf(__('Aguardando pago en CobrosYA ' . $this->medio_descripcion . '. Talón: %s', 'woocommerce'), $xml->nro_talon), 'woocommerce'));

                // Remove cart
                WC()->cart->empty_cart();

                // Return thankyou redirect
                return array(
                    'result' => 'success',
                    'redirect' => $this->get_return_url($order)
                );

            } else {

                return $xml->error;

            }

        }

    }

    /**
     * Return handler for Hosted Payments
     */
    public function check_response() {

        woocommerce_gateway_CobrosYA_check_response($this);

    }

    /**
     * Output for the order received page.
     */
    public function thankyou_page($order_id) {

        $order = wc_get_order($order_id);

        if ($order != null && 'cyaredpagos' === $order->payment_method && $order->has_status('on-hold'))

            echo wpautop(wptexturize($this->getInstructions($order->id)));

    }

    /**
     * Add content to the WC emails.
     *
     * @access public
     * @param WC_Order $order
     * @param bool $sent_to_admin
     * @param bool $plain_text
     */
    public function email_instructions($order, $sent_to_admin, $plain_text = false) {

        if (!$sent_to_admin && $order->payment_method === $this->medio_code && $order->has_status('on-hold'))

            echo wpautop(wptexturize($this->getInstructions($order->id))) . PHP_EOL;

    }

    private function getInstructions($order_id) {

        global $wpdb;

        $cya = $wpdb->get_row('SELECT * FROM '.woocommerce_gateway_CobrosYA_get_tabla_talones().' WHERE order_id = '.intval($order_id));

        return
            '<p>Para finalizar su compra deberá abonar en <b>Redpagos</b> '.((!empty($cya->fecha_vencimiento) and $cya->fecha_vencimiento != "0000-00-00") ? ('antes del <b>'.$cya->fecha_vencimiento.'</b>, ') : '').'presentando los siguientes datos:</p>
            <p>Servicio: <b>CobrosYA</b><br/>Talón: <b>' . $cya->nro_talon . '</b></p>
            <p>O <a href="' . $cya->url_pdf . '">descargar este talón haciendo click aquí</a>, imprimirlo y presentarlo al cajero de Redpagos</p>'
        ;

    }

}