<?php

/**
 * Plugin Name: WooCommerce CobrosYA.com
 * Description: Permite procesar pagos a través de CobrosYA.com
 * Version: 5.0.0
 * Author: CobrosYA.com
 * Author URI: https://www.cobrosya.com
 */

defined( 'ABSPATH' ) or die( '' );

require_once(__DIR__ . "/config.php");
require_once(__DIR__ . "/includes/cobrosya-functions.php");

add_action('plugins_loaded', 'woocommerce_gateway_CobrosYA_init', 0);

add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'woocommerce_CobrosYA_aim_action_links' );

register_activation_hook( __FILE__, 'woocommerce_gateway_CobrosYA_install' );


function woocommerce_gateway_CobrosYA_init() {

    require_once(__DIR__ . "/includes/cobrosya-visa.php");
    require_once(__DIR__ . "/includes/cobrosya-mastercard.php");
    require_once(__DIR__ . "/includes/cobrosya-diners.php");
    require_once(__DIR__ . "/includes/cobrosya-discover.php");
    require_once(__DIR__ . "/includes/cobrosya-lider.php");
    require_once(__DIR__ . "/includes/cobrosya-oca.php");
    require_once(__DIR__ . "/includes/cobrosya-redpagos.php");
    require_once(__DIR__ . "/includes/cobrosya-ebrou.php");
    require_once(__DIR__ . "/includes/cobrosya-santander.php");
    require_once(__DIR__ . "/includes/cobrosya-bbva.php");
    require_once(__DIR__ . "/includes/cobrosya-scotiabank.php");
    require_once(__DIR__ . "/includes/cobrosya-banred.php");
    require_once(__DIR__ . "/includes/cobrosya-creditel.php");
    require_once(__DIR__ . "/includes/cobrosya-cabal.php");

    /**
     * Add the Gateway to WooCommerce
     **/
    function woocommerce_add_gateway_CobrosYA_gateway($methods) {

        $methods[] = 'WC_Gateway_CobrosYA_Visa';
        $methods[] = 'WC_Gateway_CobrosYA_Oca';
        $methods[] = 'WC_Gateway_CobrosYA_Mastercard';
        $methods[] = 'WC_Gateway_CobrosYA_Diners';
        $methods[] = 'WC_Gateway_CobrosYA_Discover';
        $methods[] = 'WC_Gateway_CobrosYA_Lider';
        $methods[] = 'WC_Gateway_CobrosYA';
        $methods[] = 'WC_Gateway_CobrosYA_eBrou';
        $methods[] = 'WC_Gateway_CobrosYA_Santander';
        $methods[] = 'WC_Gateway_CobrosYA_Bbva';
        $methods[] = 'WC_Gateway_CobrosYA_Scotiabank';
        $methods[] = 'WC_Gateway_CobrosYA_Banred';
        $methods[] = 'WC_Gateway_CobrosYA_Creditel';
        $methods[] = 'WC_Gateway_CobrosYA_Cabal';

        return $methods;

    }

    add_filter('woocommerce_payment_gateways', 'woocommerce_add_gateway_CobrosYA_gateway' );

}

function woocommerce_CobrosYA_aim_action_links($links) {

    $plugin_links = array(
        '<a href="' . admin_url( 'admin.php?page=wc-settings&tab=checkout' ) . '">' . __( 'Settings', 'woocommerce' ) . '</a>',
    );

    return array_merge( $plugin_links, $links );

}